% ex8_72gf.m %
% Gaussian particle filter
clear;

d=0.5;
d2=sqrt(d);
n=4; p=2; l=2;
Q=[1000  0        % covariance of system noise
    0  100]; 
R=[1000  0        % covariance of observation noise
    0  0.001];
A=[1 d 0 0;
   0 1 0 0;
   0 0 1 d;
   0 0 0 1];
B=[d*d2/2 0;
    d2    0;
    0  d*d2/2;
    0  d2];
T=50;    % time for simulation
N=T/d;   % number of data  
%
M=200;   % number of particles
% randn('state',0);
tic
for kkk=1:10
% for kkk= 1:1000        % # of Monte Calro runs
x0=[3000 100 1000 -50]'; % Initial state
x=zeros(n,N+1);
y=zeros(p,N+1);
% generation of data 
w=sqrt(Q)*randn(l,N+1);   % system noise
v=sqrt(R)*randn(p,N+1);   % observation noise
%
x(:,1)=x0;
for k=1:N
x(:,k+1)=A*x(:,k) + B*w(:,k);
y(1,k)=sqrt(x(1,k)*x(1,k)+x(3,k)*x(3,k))+v(1,k);
y(2,k)=atan2(x(3,k),x(1,k))+v(2,k);
end
y(1,N+1)=sqrt(x(1,N+1)*x(1,N+1)+x(3,N+1)*x(3,N+1))+v(1,N+1);
y(2,N+1)=atan2(x(3,N+1),x(1,N+1))+v(2,N+1);

P0=[1000 0 0 0                  %initial value of covariance
     0 100 0 0                  %
     0 0   1000 0               %
     0 0 0 100];                %
xt0=x0;
% Gaussian Particle filter
xef=zeros(n,N+1);
Pef=zeros(n,n,N+1);
rr=R(1,1)*R(2,2);
ypart=zeros(p,1);
xpart=zeros(n,M);
xpartef=zeros(n,M);
nu=zeros(p,M);
% tic
% initialize the particle filter
for i=1:M
    xpart(:,i)=x0+sqrtm(P0)*randn(n,1);
end

for k=1:N+1  % k := time index
for i=1:M    % i := particle index
ypart(1,1)=sqrt(xpart(1,i)*xpart(1,i)+xpart(3,i)*xpart(3,i));
ypart(2,1)=atan2(xpart(3,i),xpart(1,i));
nu(:,i)=y(:,k)-ypart;
tau= nu(:,i)'*inv(R)*nu(:,i)/2;
alpha(i)=exp(-tau)/(2*pi*sqrt(rr));
end
% normalization of the likelihood 
mm=sum(alpha);
alpha=alpha./mm;
% Gaussian Particle Filter
ss=zeros(n,1);
for i=1:M
ss=ss+alpha(i)*xpart(:,i);    
end
xef(:,k)=ss;
sss=zeros(n,n);
for i=1:M
sss=sss+alpha(i)*(xpart(:,i)-ss)*(xpart(:,i)-ss)';
end
Pef(:,:,k)=sss;
[U S V]=svd(sss);
s2=U*sqrtm(S);
% predicted estimates
for i=1:M
    xpartef(:,i)=ss+s2*randn(n,1);
end
for i=1:M
xpart(:,i)=A*xpartef(:,i)+B*sqrt(Q)*randn(2,1);
end
end % of index k
% figure
for j=1:N+1
RMSE(j)=sqrt((x(1,j)-xef(1,j))^2+(x(3,j)-xef(3,j))^2);
end
rmse_GPF=mean(RMSE);
err(kkk)=rmse_GPF;
end % of kkk
error_GPF=mean(err)
Time_GPF=toc

%
J=0:N;
J=J*d;
figure(1)
plot(x(1,:),x(3,:),'r-',xef(1,:),xef(3,:),'bx','LineWidth',1.5)
grid
xlabel('x_t')
ylabel('y_t')
legend('True trajectory','Estimation by GPF')
title('True trajectory and estimation by GPF')

figure(2)
plot(J,RMSE,'mx-','LineWidth',1.5)
title('Root mean square errors of states')
xlabel('Time(sec)')
ylabel('RMSE')
grid

